// Shockwave shader from GeeXLab
// http://www.geeks3d.com/geexlab/

uniform vec2 Ratio;
uniform vec2 Resolution;
uniform vec2 ShaderPos1;
uniform sampler2D Tex0;
uniform float ShaderTime;

// Max Size (0-1.0), Speed, Wave width, NA
uniform vec4 Params;
void main() 
{ 
    vec2 texCoord = gl_TexCoord[0].xy;

    vec2 uv = gl_FragCoord.xy/Resolution.xy;
    vec2 m = ShaderPos1/Resolution;
    float distance = distance(uv, m);
    // NOTE: Cool wierd effect if don't mult by Params.y here, but do below
    if (   (distance < Params.x)
        && (distance <= (ShaderTime*Params.y + Params.z)) 
        && (distance >= (ShaderTime*Params.y - Params.z)) ) 
    {
        float diff = (distance - ShaderTime*Params.y); 
        float powDiff = 1.0 - pow(abs(diff*10.0), 0.8); 
        float diffTime = diff  * powDiff; 
        vec2 diffUV = normalize(uv - m); 
        uv += (diffUV * diffTime);
    } 
    uv *= Ratio;
    gl_FragColor = texture2D(Tex0, uv);
}
