// Apologies. Don't know where I got this from

uniform vec2 Ratio;
uniform vec2 Resolution;
uniform sampler2D Tex0;
uniform float ShaderTime;

// Noise Intensity (1=full), Scan Intensity, Effect count (4096 max), scroll speed
uniform vec4 Params;

void main(void)
{
    // sample the source
    vec2 uv = (gl_FragCoord.xy / Resolution.xy);
    vec4 cTextureScreen = texture2D( Tex0, uv*Ratio);

    // make some noise
    float x = uv.x * uv.y * ShaderTime *  1000.0;
    x = mod(x, 13.0) * mod(x, 123.0);
    float dx = mod(x, 0.01);

    vec3 cResult = cTextureScreen.rgb;
    // add noise
    cResult += cTextureScreen.rgb * clamp(0.1 + dx * 100.0, 0.0, 1.0);

    // get us a sine and cosine
    vec2 sc;
    sc.x = sin(uv.y * Params.z);
    sc.y = cos((uv.y+(ShaderTime*Params.w)) * Params.z);

    // add scanlines
    cResult += cTextureScreen.rgb * vec3(sc.x, sc.y, sc.x) * Params.y;

    // interpolate between source and result by intensity
    cResult = mix(cTextureScreen.xyz, cResult, clamp(Params.x, 0.0, 1.0));

    // convert to grayscale if desired
    // cResult.rgb = (cResult.r * 0.3f + cResult.g * 0.59f + cResult.b * 0.11f);

    gl_FragColor = vec4(cResult, cTextureScreen.a);
}
