// Based on http://www.gamerendering.com/2008/12/20/radial-blur-filter/

uniform vec2 Ratio;
uniform vec2 Resolution;
uniform vec2 ShaderPos1;
uniform sampler2D Tex0;

const int NSAMP = 5;
uniform float Samples[NSAMP];

// Sample Dist, Strength, dir.x, dir.y
// Dir gives the blur direction
// e.g. 1,-1 means moving down and right => blur trail is up and left
uniform vec4 Params;

void main(void)
{
    vec2 uv = gl_FragCoord.xy/Resolution.xy;

    vec2 dir = normalize(Params.zw);
    float dist = length((ShaderPos1/Resolution) - uv); 

    vec4 color = texture2D(Tex0,uv*Ratio); 
    vec4 sum = color;

    for (int i = 0; i < NSAMP; i++)
        sum += texture2D( Tex0, (uv + dir * Samples[i] * Params.x)*Ratio );

    sum *= 1.0/float(NSAMP+1);
    float t = dist * Params.y;
    t = clamp( t ,0.0,1.0);

    gl_FragColor = mix( color, sum, t );
}
