// Floor texture
uniform sampler3D Tex0;

void main()
{
    //const vec3  light = vec3( 0.07451, 0.45490, 1 );
    //const vec3  dark = vec3( 0,       0.28627, 0.69804 );
    const vec4  light = vec4( ::SHADER_FLOOR_LIGHT_COLOR:: );
    const vec4  dark = vec4( ::SHADER_FLOOR_DARK_COLOR:: );
    vec4 floorClr = texture3D(Tex0, gl_TexCoord[0].stp);
    if (floorClr.r > ::SHADER_FLOOR_LIGHT_LIMIT::)
    {
        floorClr = light;
    }
    else
    if (floorClr.r <= ::SHADER_FLOOR_DARK_LIMIT::)
    {
        floorClr = dark;
    }
    else
    {
        floorClr = mix(dark,light,floorClr.r);
    }
    gl_FragColor = floorClr;
}
